﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using System.Web;

namespace WebBrowser
{
	public partial class frmCheapoBrowser : Form
	{
		public frmCheapoBrowser()
		{
			InitializeComponent();
		}

		private void NavigateToCurrentUri()
		{
			try
			{
				Uri uri = new Uri(this._txtAddress.Text);
				this._webBrowser.Navigate(uri);
			}
			catch (UriFormatException ufe)
			{
				MessageBox.Show("Błąd w trakcie wyświetlania " +
							_txtAddress.Text + ": " + ufe.Message);
			}
		}

		private void frmCheapoBrowser_Load(object sender, EventArgs e)
		{
			NavigateToCurrentUri();
		}

		private void _btnBack_Click(object sender, EventArgs e)
		{
			if (this._webBrowser.CanGoBack)
			{
				this._webBrowser.GoBack();
			}
		}

		private void _btnForward_Click(object sender, EventArgs e)
		{
			if (this._webBrowser.CanGoForward)
			{
				this._webBrowser.GoForward();
			}
		}

		private void _btnCancel_Click(object sender, EventArgs e)
		{
			this._webBrowser.Stop();
		}

		private void _btnGo_Click(object sender, EventArgs e)
		{
			NavigateToCurrentUri();
		}

		private void _txtAddress_KeyPress(object sender, KeyPressEventArgs e)
		{
			if (e.KeyChar == (char)13)
			{
				NavigateToCurrentUri();
				e.Handled = true;
			}
		}

		private void _btnHome_Click(object sender, EventArgs e)
		{
			this._webBrowser.GoHome();
		}

		private void _webBrowser_Navigated(object sender, WebBrowserNavigatedEventArgs e)
		{
			// przywrócenie adresu w przypadku przekierowania z oryginalnego URI
			this._txtAddress.Text = e.Url.ToString();
			// konfiguracja przycisków, jesli można przejść wstecz lub dalej
			this._btnBack.Enabled = this._webBrowser.CanGoBack;
			this._btnForward.Enabled = this._webBrowser.CanGoForward;
		}

		private void btnAddHTML_Click(object sender, EventArgs e)
		{
			this._webBrowser.Document.Body.InnerHtml = "<h1>Hej, dodałeś kod HTML!</h1>";
		}

		private void chkEnableContextBrowser_CheckedChanged(object sender, EventArgs e)
		{
			// czy ma być wyświetlane menu podręczne?
			this._webBrowser.IsWebBrowserContextMenuEnabled = chkEnableContextBrowser.Checked;
		}

		private void btnPrint_Click(object sender, EventArgs e)
		{
			// drukowanie
			this._webBrowser.Print();
			// wyświetlenie ustawień strony, by móc modyfikować ustawienia drukowania
			this._webBrowser.ShowPageSetupDialog();
			// wyświetlenie okna dialogowego drukowania
			this._webBrowser.ShowPrintDialog();
			// wyświetlenie podglądu wydruku
			this._webBrowser.ShowPrintPreviewDialog();
		}

		private void btnSaveAs_Click(object sender, EventArgs e)
		{
			this._webBrowser.ShowSaveAsDialog();
		}
	}
}